/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import tools.javazic.Main;
import tools.javazic.RuleRec;
import tools.javazic.Time;
import tools.javazic.Zoneinfo;

class Rule {
    private List<RuleRec> list;
    private String name;

    Rule(String string) {
        this.name = string;
        this.list = new ArrayList<RuleRec>();
    }

    void add(RuleRec ruleRec) {
        this.list.add(ruleRec);
    }

    String getName() {
        return this.name;
    }

    List<RuleRec> getRules(int n) {
        ArrayList<RuleRec> arrayList = new ArrayList<RuleRec>(3);
        for (RuleRec ruleRec : this.list) {
            if (n < ruleRec.getFromYear() || n > ruleRec.getToYear() || ruleRec.isOdd() && n % 2 == 0 || ruleRec.isEven() && n % 2 == 1) continue;
            arrayList.add(ruleRec);
        }
        int n2 = arrayList.size();
        if (n2 <= 1) {
            return arrayList;
        }
        if (n2 == 2) {
            long l;
            long l2;
            RuleRec ruleRec;
            ruleRec = (RuleRec)arrayList.get(0);
            RuleRec ruleRec2 = (RuleRec)arrayList.get(1);
            if (ruleRec.getMonthNum() > ruleRec2.getMonthNum()) {
                arrayList.set(0, ruleRec2);
                arrayList.set(1, ruleRec);
            } else if (ruleRec.getMonthNum() == ruleRec2.getMonthNum() && (l2 = Time.getLocalTime(n, ruleRec.getMonth(), ruleRec.getDay(), ruleRec.getTime().getTime())) > (l = Time.getLocalTime(n, ruleRec2.getMonth(), ruleRec2.getDay(), ruleRec2.getTime().getTime()))) {
                arrayList.set(0, ruleRec2);
                arrayList.set(1, ruleRec);
            }
            return arrayList;
        }
        final int n3 = n;
        RuleRec[] ruleRecArray = new RuleRec[arrayList.size()];
        arrayList.toArray(ruleRecArray);
        Arrays.sort(ruleRecArray, new Comparator<RuleRec>(){

            @Override
            public int compare(RuleRec ruleRec, RuleRec ruleRec2) {
                int n = ruleRec.getMonthNum() - ruleRec2.getMonthNum();
                if (n != 0) {
                    return n;
                }
                long l = Time.getLocalTime(n3, ruleRec.getMonth(), ruleRec.getDay(), ruleRec.getTime().getTime());
                long l2 = Time.getLocalTime(n3, ruleRec2.getMonth(), ruleRec2.getDay(), ruleRec2.getTime().getTime());
                return Long.valueOf(l).compareTo(l2);
            }

            @Override
            public boolean equals(Object object) {
                return this == object;
            }
        });
        arrayList.clear();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(ruleRecArray[i]);
        }
        return arrayList;
    }

    List<RuleRec> getLastRules() {
        int n;
        RuleRec ruleRec = null;
        RuleRec ruleRec2 = null;
        for (n = 0; n < this.list.size(); ++n) {
            RuleRec ruleRec3 = this.list.get(n);
            if (!ruleRec3.isLastRule()) continue;
            if (ruleRec3.getSave() > 0) {
                ruleRec = ruleRec3;
                continue;
            }
            ruleRec2 = ruleRec3;
        }
        if (ruleRec == null || ruleRec2 == null) {
            n = Zoneinfo.getEndYear();
            for (int i = 0; i < this.list.size(); ++i) {
                RuleRec ruleRec4 = this.list.get(i);
                if (n < ruleRec4.getFromYear() || n > ruleRec4.getToYear()) continue;
                if (ruleRec == null && ruleRec4.getSave() > 0) {
                    ruleRec = ruleRec4;
                    continue;
                }
                if (ruleRec2 != null || ruleRec4.getSave() != 0) continue;
                ruleRec2 = ruleRec4;
            }
        }
        ArrayList<RuleRec> arrayList = new ArrayList<RuleRec>(2);
        if (ruleRec == null || ruleRec2 == null) {
            if (ruleRec != null || ruleRec2 != null) {
                Main.warning("found last rules for " + this.name + " inconsistent.");
            }
            return arrayList;
        }
        arrayList.add(ruleRec);
        arrayList.add(ruleRec2);
        return arrayList;
    }
}

